<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Messages Controller
 *
 * @property \App\Model\Table\MessagesTable $Messages
 */
class MessagesController extends AppController
{

    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
        // Allow unauthenticated users to access the 'add' action
        $this->Authentication->allowUnauthenticated(['add']);
    }

    public function initialize(): void
    {
        parent::initialize();

        // Load the Recaptcha component and configure it
        $this->loadComponent('Recaptcha.Recaptcha', [
            'enable' => true,
            'sitekey' => '6Lc-AP4qAAAAAOTRl2PpS8DC_B41GIbjnDpzT2KO', // Replace with your reCAPTCHA site key
            'secret' => '6Lc-AP4qAAAAABsDordH_WIVaJfvHNaVG1DrSBk2', // Replace with your reCAPTCHA secret key
            'type' => 'image', // or 'audio' for audio challenge
            'theme' => 'light', // or 'dark'
            'lang' => 'en', // Change to the desired language code
            'size' => 'normal', // 'normal' or 'compact'
            'callback' => null, // Optional: provide a callback function
            'scriptBlock' => true // True to include the reCAPTCHA script
        ]);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Messages->find();
        $messages = $this->paginate($query);

        $this->set(compact('messages'));
    }

    /**
     * View method
     *
     * @param string|null $id Message id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $message = $this->Messages->get($id, contain: []);
        $this->set(compact('message'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $message = $this->Messages->newEmptyEntity();
        if ($this->request->is('post')) {
            if ($this->Recaptcha->verify()) { // if configure enable = false, it will always return true
                $message = $this->Messages->patchEntity($message, $this->request->getData());
                if ($this->Messages->save($message)) {
                    $this->Flash->success(__('The message has been saved. Thanks for contacting with us'));

                    return $this->redirect(['action' => 'add']);
                }
                $this->Flash->error(__('The message could not be saved. Please, try again.'));
            }
            $this->Flash->error(__('Please pass Google Recaptcha first'));

        }
        $this->set(compact('message'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Message id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $message = $this->Messages->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $message = $this->Messages->patchEntity($message, $this->request->getData());
            if ($this->Messages->save($message)) {
                $this->Flash->success(__('The message has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The message could not be saved. Please, try again.'));
        }
        $this->set(compact('message'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Message id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $message = $this->Messages->get($id);
        if ($this->Messages->delete($message)) {
            $this->Flash->success(__('The message has been deleted.'));
        } else {
            $this->Flash->error(__('The message could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
