<?php
declare(strict_types=1);

namespace App\Error;

use Cake\Controller\Controller;
use Cake\Error\ExceptionRenderer;
use Cake\Http\Response;

class AppError extends ExceptionRenderer
{
    public function render(): Response
    {
        // If controller is not set, create one so we can do a redirect.
        $controller = $this->controller ?? new Controller($this->request);

        // (Optional) Load Flash to show a user-friendly message
        $controller->loadComponent('Flash');
        $controller->Flash->error('An error occurred. Redirecting to home.');

        // Always redirect to home
        return $controller->redirect('/');
    }
}
