<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Message $message
 */
?>

<head>
    <meta charset="UTF-8" >
    <meta name="viewport" content="width=device-width, initial-scale=1.0" >
    <style>
        body {
            background-color: #C5A691;
        }
    </style>
    <title>Login Page</title>
</head>
<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-light" style="background-color: #C5A691;">
    <div class="container" style="width: 100%">
        <a class="navbar-brand" href="/" style="font-size: 2rem;">PowerProShop</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav" >
            <ul class="navbar-nav ms-auto">
                <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
                <!--<li class="nav-item"><a class="nav-link" href="#contact">Contact Us</a></li>-->
                <!-- <a href="<?= $this->Url->build(['controller' => 'Messages', 'action' => 'add']) ?>"> Contact Us </a>-->
                <li class="nav-item"><a class="nav-link" href="<?= $this->Url->build(['controller' => 'Messages', 'action' => 'add']) ?>">Contact Us</a></li>
                <a href="<?= $this->Url->build(['controller' => 'Users', 'action' => 'login']) ?>" class="btn btn-lg rounded text-white" style="background-color: #5B4130;">Login</a>
                <!--<a href="<?= $this->Url->build(['controller' => 'Users', 'action' => 'logout']) ?>" class="btn btn-primary btn-lg rounded">Log out</a>-->
            </ul>
        </div>
    </div>
</nav>

<!-- Main Content -->
<div class="container my-5"  style="background-color: #C5A691;">
    <div class="row" >
        <!-- Main Form -->
        <div class="col-md-11" >
            <h2 class="text-center mb-4">Contact Us</h2>
            <div class="messages form content">
                <?= $this->Flash->render() ?>
                <?= $this->Form->create($message) ?>
                <fieldset>
                    <?php
                    echo $this->Form->control('name', ['class' => 'form-control mb-3', 'label' => 'Your Name']);
                    echo $this->Form->control('email', ['class' => 'form-control mb-3', 'label' => 'Your Email']);
                    echo $this->Form->control('message', ['class' => 'form-control mb-3', 'type' => 'textarea', 'label' => 'Your Message']);
                    echo $this->Recaptcha->display();
                    ?>
                </fieldset>
                <div class="text-center">
                    <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-lg', 'style' => 'background-color: #5B4130; color: white; border-color: #5B4130;' ]) ?>

                </div>
                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
</div>

<!-- Footer -->

<footer class="text-white text-center py-4"  style="background-color: #C5A691;">
    <p>&copy; <?= date('Y') ?> Our Service. All Rights Reserved.</p>
</footer>
