<?php ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PowerProShop</title>
    <style>
        html, body {
            height: 100%;
            margin: 0;
            overflow-x: hidden;
            max-width: 100%;
        }

        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        main {
            flex: 1 0 auto;
        }

        footer {
            flex-shrink: 0;
        }
        footer {
            background-color: #C5A691;
            color: #000;
        }

        footer a {
            color: #000 !important; /* Force black color */
            text-decoration: none;
        }

        footer a:hover {
            color: #333; /* Slightly darker on hover */
        }
        .welcome-title {
            font-size: 2.5rem;
            font-weight: bold;
            color: #3D2E1E; /* Darker text for contrast */
            margin-bottom: 15px;
        }

        .welcome-description {
            max-width: 600px; /* Restrict width for better readability */
            margin: 0 auto; /* Centers the text block */
            font-size: 1.2rem;
            line-height: 1.6;
            color: #fff;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light" style="background-color: #C5A691;">
    <div class="container" style="width: 100%">
        <a class="navbar-brand" href="/" style="font-size: 2rem;">PowerProShop</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
                <li class="nav-item"><a class="nav-link" href="<?= $this->Url->build(['controller' => 'Messages', 'action' => 'add']) ?>">Contact Us</a></li>
                <a href="<?= $this->Url->build(['controller' => 'Users', 'action' => 'login']) ?>" class="btn btn-lg rounded text-white" style="background-color: #5B4130;">Login</a>
            </ul>
        </div>
    </div>
</nav>

<header class="text-center text-white py-5" style="background-color: #8C6E5D;">
    <div class="container">
        <h1 class="welcome-title">Welcome to PowerProShop</h1>
        <p class="welcome-description">
            PowerProShop is your go-to destination for premium fitness gear, gym equipment, and performance essentials.
            Whether you're a beginner or a seasoned athlete, we provide high-quality products designed to elevate your training experience.
            Shop with confidence and power up your workouts today!
        </p>
    </div>
</header>

<main class="container py-5">
    <section>
        <h2>New Arrivals</h2>
        <div class="row">
            <div class="col"><img src="/img/gym1.jpg" alt="New Arrival"></div>
            <div class="col"><img src="/img/gym1.jpg"" alt="New Arrival"></div>
            <div class="col"><img src="/img/gym1.jpg"" alt="New Arrival"></div>
            <div class="col"><img src="/img/gym1.jpg"" alt="New Arrival"></div>
        </div>
    </section>

    <section>
        <h2>On Sale</h2>
        <div class="row">
            <div class="col"><img src="/img/gym2.jpg" alt="On Sale"></div>
            <div class="col"><img src="/img/gym2.jpg" alt="On Sale"></div>
            <div class="col"><img src="/img/gym2.jpg" alt="On Sale"></div>
            <div class="col"><img src="/img/gym2.jpg" alt="On Sale"></div>
        </div>
    </section>

    <section>
        <h2>Reviews</h2>
        <div class="row">
            <div class="col"><img src="/img/gym3.jpg" alt="Review"></div>
            <div class="col"><img src="/img/gym3.jpg" alt="Review"></div>
            <div class="col"><img src="/img/gym3.jpg" alt="Review"></div>
        </div>
    </section>
</main>

<footer class="py-4" style="background-color: #C5A691; color: #000;">
    <div class="container">
        <div class="row">
            <!-- Column 1: About -->
            <div class="col-md-4">
                <h5>About Us</h5>
                <p>We provide high-quality products and services to meet your fitness needs.</p>
            </div>

            <!-- Column 2: Quick Links -->
            <div class="col-md-4">
                <h5>Quick Links</h5>
                <ul class="list-unstyled">
                    <li><?= $this->Html->link('Home', ['controller' => 'Pages', 'action' => 'display', 'home']) ?></li>
                    <li><?= $this->Html->link('Shop', ['controller' => 'Products', 'action' => 'index']) ?></li>
                    <li><?= $this->Html->link('Contact Us', ['controller' => 'Pages', 'action' => 'contact']) ?></li>
                </ul>
            </div>

            <!-- Column 3: Contact -->
            <div class="col-md-4">
                <h5>Contact Us</h5>
                <p>Email: support@example.com</p>
                <p>Phone: +61 456 7890</p>
                <p>Address: Monash Uni</p>
            </div>
        </div>
    </div>
</footer>
</body>
</html>
