<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Page</title>
    <style>
        .login-container {
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .login-form {
            max-width: 400px;
            width: 100%;
            padding: 2rem;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light" style="background-color: #C5A691;">
    <div class="container" style="width: 100%">
        <a class="navbar-brand" href="/" style="font-size: 2rem;">PowerProShop</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav" >
            <ul class="navbar-nav ms-auto">
                <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
                <!--<li class="nav-item"><a class="nav-link" href="#contact">Contact Us</a></li>-->
                <!-- <a href="<?= $this->Url->build(['controller' => 'Messages', 'action' => 'add']) ?>"> Contact Us </a>-->
                <li class="nav-item"><a class="nav-link" href="<?= $this->Url->build(['controller' => 'Messages', 'action' => 'add']) ?>">Contact Us</a></li>
                <a href="<?= $this->Url->build(['controller' => 'Users', 'action' => 'login']) ?>" class="btn btn-lg rounded text-white" style="background-color: #5B4130;">Login</a>
                <!--<a href="<?= $this->Url->build(['controller' => 'Users', 'action' => 'logout']) ?>" class="btn btn-primary btn-lg rounded">Log out</a>-->
            </ul>
        </div>
    </div>
</nav>
<div class="login-container" style="background-color: #C5A691;">
    <div class="login-form bg-white">
        <h3 class="text-center mb-4"><?= __('Login') ?></h3>
        <?= $this->Flash->render() ?>
        <?= $this->Form->create() ?>
        <fieldset >
            <div class="mb-3">
                <?= $this->Form->control('email', ['class' => 'form-control', 'label' => 'Email', 'required' => true]) ?>
            </div>
            <div class="mb-3">
                <?= $this->Form->control('password', ['class' => 'form-control', 'label' => 'Password', 'required' => true]) ?>
            </div>
        </fieldset>
        <?= $this->Form->button(__('Login'), ['class' => 'btn w-100', 'style' => 'background-color: #5B4130; color: white; border-color: #5B4130;']) ?>
        <div class="text-center mt-2">
            <?= $this->Html->link(
                'Forgot Password?',
                ['controller' => 'Users', 'action' => 'forgotPassword'],
                ['style' => 'color: #5B4130; text-decoration: underline; font-size: 0.9rem;']
            ) ?>
        </div>

        <?= $this->Form->end() ?>
    </div>
</div>
<footer class="bg-dark text-white text-center py-3">
    <p>&copy; <?php echo date("Y"); ?> Our Service. All rights reserved.</p>
</footer>

</body>
</html>
