<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework';
?>
<!DOCTYPE html>
<html>
<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?= $cakeDescription ?>:
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon') ?>
    <?= $this->Html->css(['normalize.min', 'milligram.min', 'fonts', 'cake']) ?>
    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>
<body>

<!-- ✅ NAVBAR START -->
<nav class="navbar navbar-expand-lg navbar-light" style="background-color: #C5A691;">
    <div class="container-fluid px-4">
        <a class="navbar-brand fw-bold" href="<?= $this->Url->build('/') ?>">PowerProShop</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
                <li class="nav-item"><a class="nav-link" href="<?= $this->Url->build(['controller' => 'Messages', 'action' => 'add']) ?>">Contact Us</a></li>

                <li class="nav-item">
                    <?php if ($this->Identity->isLoggedIn()): ?>
                        <?= $this->Html->link(
                            'Logout',
                            ['controller' => 'Users', 'action' => 'logout'],
                            ['class' => 'btn btn-sm text-white ms-3', 'style' => 'background-color: #5B4130;']
                        ) ?>
                    <?php else: ?>
                        <?= $this->Html->link(
                            'Login',
                            ['controller' => 'Users', 'action' => 'login'],
                            ['class' => 'btn btn-sm text-white ms-3', 'style' => 'background-color: #5B4130;']
                        ) ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    </div>
</nav>
<!-- ✅ NAVBAR END -->

<!-- MAIN SECTION -->
<main>
    <div>
        <?= $this->Flash->render() ?>
        <?= $this->fetch('content') ?>
    </div>
</main>

</body>
</html>
